using System;
using System.Collections.Generic;
using System.Text;

namespace PI.ZB.N1200.ELearning.WinForms.Common
{
    /// <summary>
    /// Pomocniczy kesz dla klas i szk i instruktorw
    /// </summary>
    public static class Cache
    {
        private static Dictionary<long?, BL.BO.Class> _dictionaryClass = new Dictionary<long?, BL.BO.Class>();
        private static Dictionary<long?, BL.BO.School> _dictionarySchool = new Dictionary<long?, BL.BO.School>();
        private static Dictionary<long?, BL.BO.Instructor> _dictionaryInstructor = new Dictionary<long?, BL.BO.Instructor>();
        private static Dictionary<long?, BL.BO.Competence> _dictionaryCompetence = new Dictionary<long?, BL.BO.Competence>();

        /// <summary>
        /// Pobiera szko i w razie czego ddoaje j do cache na przyszo
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public static BL.BO.School GetSchool(long? ID)
        {
            if (!_dictionarySchool.ContainsKey(ID))
            {
                BL.BO.School _school = RBLELearning.RBL.ZSBELearning.School.Restore(ID);
                if (_school != null)
                {
                    _dictionarySchool.Add(ID, _school);
                }
                else
                {
                    return null;
                }
            }
            return _dictionarySchool[ID];
        }

        /// <summary>
        /// Pobiera klase i w razie czego ddoaje j do cache na przyszo
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public static BL.BO.Class GetClass(long? ID)
        {
            if (!_dictionaryClass.ContainsKey(ID))
            {
                BL.BO.Class _Class = RBLELearning.RBL.ZSBELearning.Class.RestoreById(ID);
                if (_Class != null)
                {
                    _dictionaryClass.Add(ID, _Class);
                }
                else
                {
                    return null;
                }
            }
            return _dictionaryClass[ID];
        }

        

        /// <summary>
        /// Pobiera dane szkoy na podstawie klasy
        /// </summary>
        /// <param name="ClassID"></param>
        /// <returns></returns>
        public static BL.BO.School GetSchoolByClass(long? ClassID)
        {
            BL.BO.Class _class = RBLELearning.RBL.ZSBELearning.Class.RestoreById(ClassID);
            if (_class != null)
            {
                return GetSchool(_class.SchoolID);
            }
            return null;
        }

        /// <summary>
        /// Pobiera Instructor'a z cache jak moe a jak nie to z bazy i zapisuje do cache
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public static BL.BO.Instructor GetInstructor(long? ID)
        {
            if (!_dictionaryInstructor.ContainsKey(ID))
            {
                BL.BO.Instructor _instructor = RBLELearning.RBL.ZSBELearning.Instructor.Restore(ID);
                if (_instructor != null)
                {
                    _dictionaryInstructor.Add(ID, _instructor);
                }
                else
                {
                    return null;
                }
            }
            return _dictionaryInstructor[ID];
        }

        public static BL.BO.Competence GetCompetence(long? ID)
        {
            if (!_dictionaryCompetence.ContainsKey(ID))
            {
                BL.BO.Competence _competence = RBLELearning.RBL.ZSBELearning.Competence.Restore(ID);
                if (_competence != null)
                {
                    _dictionaryCompetence.Add(ID, _competence);
                }
                else
                {
                    return null;
                }
            }
            return _dictionaryCompetence[ID];
        }

        private static Dictionary<long, string> _difficulty = new Dictionary<long, string>();

        public static Dictionary<long, string> Difficulty
        {
            get { return _difficulty; }
        }

        internal static void Clear()
        {
            _dictionaryClass.Clear();
            _dictionarySchool.Clear();
            _dictionaryInstructor.Clear();
            _dictionaryCompetence.Clear();
        }
    }
}